*-------------------------------------------------------------------------------
*						Appendix V Fig A1
*-------------------------------------------------------------------------------

** Set Path
global Raw_data    	"G:\project-finished\Descriptive\Data"
global App_data    	"G:\project-finished\Descriptive\Appendix Data"
global Class_data   "G:\project-finished\Descriptive\Classification"  
global Work_lab   	"G:\project-finished\Descriptive\Lab"
global Out_lab    	"G:\project-finished\Descriptive\Out"  

cd "$Work_lab"
                            
capture log close            
log using "$Out_lab\Appendix V Fig A1", replace 
set more off     


**------------------------------------------------------------------------------
* Step1: Generate Data
**------------------------------------------------------------------------------
clear
set obs 0
save tabledata,replace emptyok


*Chinese census data: change occ category and industry category
foreach j in "2000" "2010" "2015"{
use "`j'census_consistent.dta",clear

gen id_new=_n
collapse (count) id_new,by(consistent title_consistent new new_title)

gen sector="农" if real(substr(new,1,2))<=5
replace sector="工" if real(substr(new,1,2))>5 & real(substr(new,1,2))<=59
replace sector="服务" if real(substr(new,1,2))>59

bys consistent title_consistent:egen occ_pop=total(id_new)
gen ind_share=id_new/occ_pop*100

bys consistent title_consistent sector:egen sector_pop=total(id_new)
gen sec_share=sector_pop/occ_pop*100

keep consistent title_consistent new new_title sector ind_share sec_share 
duplicates drop 

gen year=`j'

append using tabledata
save tabledata,replace
}




**------------------------------------------------------------------------------
* Step2: Plot Data
**------------------------------------------------------------------------------
//industry level
use tabledata,clear
drop sector sec_share
reshape wide ind_share,i(consistent title_consistent new new_title) j(year)
foreach i in "2000" "2010" "2015"{
replace ind_share`i'=0 if ind_share`i'==.
}


*Re_d
foreach var in "ind"{
gen d_`var'_share0010=(`var'_share2010-`var'_share2000)/(`var'_share2010+`var'_share2000)*2
replace d_`var'_share0010=2.1 if d_`var'_share0010==2
replace d_`var'_share0010=-2.1 if d_`var'_share0010==-2

gen d_`var'_share1015=(`var'_share2015-`var'_share2010)/(`var'_share2015+`var'_share2010)*2
replace d_`var'_share1015=2.1 if d_`var'_share1015==2
replace d_`var'_share1015=-2.1 if d_`var'_share1015==-2
}

twoway (histogram d_ind_share0010 if abs(d_ind_share0010)<2,frac width(0.1) color(red%40)) ///
 (histogram d_ind_share1015 if abs(d_ind_share1015 )<2,frac width(0.1) color(black%40)) ///
 ,scheme(plotplain) xlabel(,nogrid) ylabel(,nogrid) ///
 legend (label(1 2000-2010) label(2 2010-2015) position(6) rows(1)) xtitle("职业o在行业j层面的相对就业结构变动")
graph save "$Out_lab\appV_Figa1",replace
graph export "$Out_lab\appV_Figa1.png",replace


//sector level
use tabledata,clear
drop new new_title ind_share
duplicates drop
reshape wide sec_share,i(consistent title_consistent sector) j(year)
foreach i in "2000" "2010" "2015"{
replace sec_share`i'=0 if sec_share`i'==.
}


*Re_d
foreach var in "sec"{
gen d_`var'_share0010=(`var'_share2010-`var'_share2000)/(`var'_share2010+`var'_share2000)*2
replace d_`var'_share0010=2.1 if d_`var'_share0010==2
replace d_`var'_share0010=-2.1 if d_`var'_share0010==-2

gen d_`var'_share1015=(`var'_share2015-`var'_share2010)/(`var'_share2015+`var'_share2010)*2
replace d_`var'_share1015=2.1 if d_`var'_share1015==2
replace d_`var'_share1015=-2.1 if d_`var'_share1015==-2
}
 

keep consistent title_consistent sector sec_share2000 sec_share2010 sec_share2015 d_sec_share0010 d_sec_share1015


twoway (histogram d_sec_share0010 if abs(d_sec_share0010)<2,frac width(0.1) color(red%40) yaxis(1)) ///
 (histogram d_sec_share1015 if abs(d_sec_share1015)<2,frac width(0.1) color(black%50) yaxis(1)) ///
 ,scheme(plotplain) xlabel(,nogrid) ylabel(,nogrid) ///
 legend (label(1 2000-2010) label(2 2010-2015) position(6) rows(1)) xtitle("职业o在产业s层面的相对就业结构变动")
graph save "$Out_lab\appV_Figa1",replace
graph export "$Out_lab\appV_Figa1.png",replace


erase tabledata.dta

log close

